package com.ejie.ab04b.constantes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

import com.ejie.ab04b.model.comun.Elemento;
import com.ejie.ab04b.model.comun.ElementoCombo;

/**
 * 
 * @author GFI-NORTE
 * 
 */
public final class Constantes {

	/**
	 * Constructor de Constantes.
	 */
	private Constantes() {

	}

	// Código aplicación
	public static final String APLICACION = "AB04B";
	public static final String APLICACION_OLD = "M01B";

	// Nombre del WAR
	public static final String NOMBRE_WAR_APERTURAS = "ab04bAperturasWar";

	// Constantes para el Idioma
	public static final String EU = com.ejie.x38.util.Constants.EUSKARA;
	public static final String ES = com.ejie.x38.util.Constants.CASTELLANO;
	public static final Locale LOCALE_ES = new Locale(Constantes.ES, "", "");
	public static final Locale LOCALE_EU = new Locale(Constantes.EU, "", "");

	// Roles
	public static final String ROL_TRAMITADOR_ALAVA = "AB04B-IN-0004";
	public static final String ROL_TRAMITADOR_GIPUZKOA = "AB04B-IN-0005";
	public static final String ROL_TRAMITADOR_BIZKAIA = "AB04B-IN-0006";
	public static final String ROL_TRAMITADOR_OSALAN_ALAVA = "AB04B-IN-0007";
	public static final String ROL_TRAMITADOR_OSALAN_BIZKAIA = "AB04B-IN-0008";
	public static final String ROL_TRAMITADOR_OSALAN_GIPUZKOA = "AB04B-IN-0009";
	public static final String ROL_CONSULTA_ALAVA = "AB04B-IN-0011";
	public static final String ROL_CONSULTA_BIZKAIA = "AB04B-IN-0012";
	public static final String ROL_CONSULTA_GIPUZKOA = "AB04B-IN-0013";
	public static final String ROL_CONSULTA_OSALAN_ALAVA = "AB04B-IN-0014";
	public static final String ROL_CONSULTA_OSALAN_BIZKAIA = "AB04B-IN-0015";
	public static final String ROL_CONSULTA_OSALAN_GIPUZKOA = "AB04B-IN-0016";

	public static final String ROL_ADMIN = "AB04B-IN-0002";
	public static final String ROL_INSPECCION = "AB04B-IN-0010";

	// Formato de fechas
	public static final String EU_DATE_MASK = "yyyy/MM/dd";
	public static final String ES_DATE_MASK = "dd/MM/yyyy";

	// Estudio documentacion

	public static final String ESTUDIO_DOC_RESULT_OK = "DOCU_CORRECTA";
	public static final String ESTUDIO_DOC_RESULT_REQ = "REQ_SUBSANA";
	public static final String ESTUDIO_DOC_CDT_RESULT_OK = "Documentacion Correcta";
	public static final String ESTUDIO_DOC_CDT_RESULT_REQ = "Requiere Subsanacion";

	// Requerimiento
	public static final String MOTIVO_SUBSANACION_OBRA = "100";
	public static final String MOTIVO_SUBSANACION_PROMOTOR = "200";
	public static final String MOTIVO_SUBSANACION_COORDINADOR = "300";
	public static final String MOTIVO_SUBSANACION_FALTADOC = "400";
	public static final String MOTIVO_SUBSANACION_OTROS = "500";

	// Valores Si - No
	public static final String VALUE_NO = "N";
	public static final String VALUE_SI = "S";

	public static final Integer VALUE_INT_NO = 0;
	public static final Integer VALUE_INT_SI = 1;

	// Valores Todas - Pendientes
	public static final String VALUE_TODAS = "T";
	public static final String VALUE_PENDIENTES = "P";

	public static final String APERTURA_SUBTIPO_NUEVA_CREACION = "1";
	public static final String APERTURA_SUBTIPO_REANUDACION_ACTIVIDAD = "2";
	public static final String APERTURA_SUBTIPO_CAMBIO_ACTIVIDAD = "3";
	public static final String APERTURA_SUBTIPO_TRASLADO = "4";
	public static final String APERTURA_SUBTIPO_CAMBIO_RAZON_SOCIAL = "5";

	public static final Long UMBRAL_NUMERO_TRABAJADORES_CENTRO = 50L;

	public static final String EMPRESA_NUEVA = "N";
	public static final String EMPRESA_EXISTENTE = "E";

	public static final String PROMOTOR_PRINCIPAL = "P";
	public static final String PROMOTOR_SECUNDARIO = "S";

	public static final String COORDINADOR_ELABORACION_PROYECTO = "P";
	public static final String COORDINADOR_EJECUCION_OBRA = "E";

	public static final String HIST_MODIF_MIGRADO_S = "S";
	public static final String HIST_MODIF_MIGRADO_N = "N";
	public static final String HIST_MODIF_MIGRADO_A = "A";

	// Valores toolkit

	public static final String TOOLKIT_SI = "Si";
	public static final String TOOLKIT_NO = "No";

	// Tipo tarea
	public static final String ENTRADA = "E";
	public static final String SALIDA = "S";
	public static final String AUTOMATICA = "A";

	// Canal de notificación
	public static final String CANAL_NOTIF_TELEMATICO = "0";
	public static final String CANAL_NOTIF_POSTAL = "1";

	// Canal de notificación
	public static final String TIPO_PRESENTACION_TELEMATICO = "T";
	public static final String TIPO_PRESENTACION_PRESENCIAL = "P";

	// Idioma de notificación
	public static final String IDIOMA_NOTIF_CASTELLANO = "0";
	public static final String IDIOMA_NOTIF_EUSKERA = "1";

	// Canal de aviso
	public static final Integer CANAL_AVISO_SMS = 0;
	public static final Integer CANAL_AVISO_EMAIL = 1;

	// Unidad de tiempo duración obra
	public static final String UNIDAD_TIEMPO_DIAS = "D";
	public static final String UNIDAD_TIEMPO_MESES = "M";
	public static final String UNIDAD_TIEMPO_ANYOS = "A";

	// Tablones
	public static final String TABLON_PERIODO_PRESENTACION = "PERIODO_PRESEN";
	public static final String TABLON_ESTADO_CIERRE = "ESTADO_CIERRE";
	public static final String TABLON_TIPO_CAMBIO = "TIPO_CAMBIO";
	public static final String TABLON_ESTADO_VISITA_OSALAN = "EST_VISOSL";
	public static final String TABLON_RESULTADO_ESTUDIO_DOC = "ESTUDIO_RESULT";
	public static final String TABLON_UNIDAD_TEMPORAL_DURACION_OBRA = "UNITEMP_DUROBRA";
	public static final String TABLON_CANAL_PRESENTACION = "CANAL_PRESENT";
	public static final String TABLON_TIPO_COMUNICACION_PRL = "TIPO_COMUNICA";
	// Aunque pone ...REENV esta es la que recupera todos los tipos de
	// comunicaciones
	public static final String TABLON_TIPO_COMUNICACION = "TIPO_COM_REENV";
	public static final String TABLON_ESTADO_COMUNICACION_PRL = "ESTADO_COMUNICA";
	public static final String TABLON_MOTIVOS_SUBSANACION = "MOTIVOS_SUBSANA";
	public static final String TABLON_MOTIVOS_SUBSANACION_OS2 = "MOTIVOS_SUB_OS2";
	public static final String TABLON_MOTIVOS_SUBSANACION_OS3 = "MOTIVOS_SUB_OS3";
	public static final String TABLON_ESTADO_ENVIO = "ESTADO_ENVIO";
	public static final String TABLON_TIPOS_EXPEDIENTE = "TIPO_EXP";

	public static final String TABLON_TIPO_COMUNICACION_REENVIO = "TIPO_COM_REENV";

	public static final String TABLON_TIPOS_PARTICIPANTE = "TIPO_PARTICIP";

	// Territorios
	public static final String TH_TODOS = "99";
	public static final String TH_ALAVA = "01";
	public static final String TH_BIZKAIA = "48";
	public static final String TH_GIPUZKOA = "20";

	public static final String DESC_TH_TODOS_ES = "TODOS";
	public static final String DESC_TH_TODOS_EU = "TODOS";
	public static final String DESC_TH_ALAVA = "ARABA";
	public static final String DESC_TH_BIZKAIA = "BIZKAIA";
	public static final String DESC_TH_GIPUZKOA = "GIPUZKOA";

	// Modos de acceso a la aplicación
	public static final String MODO_ACCESO_ALTA = "ALTA";
	public static final String MODO_ACCESO_CONSULTA = "CONSULTA";
	public static final String MODO_ACCESO_MANTENIMIENTO = "MANTENIMIENTO";
	public static final String MODO_ACCESO_SUBSANACION = "SUBSANACION";
	public static final String MODO_ACCESO_INSPECCION = "INSPECCION";
	public static final String MODO_ACCESO_OSALAN = "OSALAN";
	public static final String MODO_ACCESO_HISTORICO = "HISTORICO";

	// Estado cierre
	public static final String ESTADO_ABIERTO = "A";
	public static final String ESTADO_CERRADO = "C";
	public static final String ESTADO_ELIMINADO = "E";
	public static final String ESTADO_PROCESO_CIERRE = "P";

	// Origen de documento
	public static final Integer DOCUMENTO_ORIGEN_CIUDADANO = 0;
	public static final Integer DOCUMENTO_ORIGEN_ADMINISTRACION = 1;

	public static final String NOMBRE_DOCUMENTO_ESCANEADO_DOKUSI = "documentoDigitalizado_";

	// Documento generado o aportado
	public static final String TIPO_DOCUMENTO_APORTADO = "A";
	public static final String TIPO_DOCUMENTO_GENERADO = "G";

	// Documento Informe Inspección Trabajo
	public static final String TIPO_DOC_INFORME_INSPECCION = "W20_INF_INSPECCION";
	public static final Long ID_TIPO_DOC_INFORME_INSPECCION = 15L;

	// Formato de aportación de documento
	public static final String FORMATO_APORTACION_PAPEL = "P";
	public static final String FORMATO_APORTACION_ELECTRONICO = "E";

	// Tipos de extensiones
	public static final String EXT_PDF = "pdf";
	public static final String EXT_PDFA = "pdfa";

	// Nombres de ficheros
	public static final String NOM_FICH_REQ_PDF = "requerimiento.pdf";
	public static final String NOM_FICH_CARTA_CONTRATISTA_PDF = "carta_contratista.pdf";
	public static final String NOM_FICH_COMUNICACION_OS2_PDF = "comunicacion_os2.pdf";
	public static final String NOM_FICH_COMUNICACION_OS3_PDF = "comunicacion_os3.pdf";
	public static final String NOM_FICH_COMUNIC_CAMBIO_COORDINADOR_PDF = "comunicacion_cambio_coordinador.pdf";
	public static final String NOM_FICH_VISITA_OSALAN_PDF = "informe_visita_Osalan.pdf";
	public static final String NOM_FICH_INSPECCION_PDF = "informe_inspeccion.pdf";

	// Detalles destinatarios comunicaciones
	public static final String DEST_CARTA_CONTRATISTA = " (Att. contratista)";

	// Estados visita OSALAN
	public static final String ESTADO_VISITA_NO_VISITAR = "1";
	public static final String ESTADO_VISITA_VISITAR = "2";
	public static final String ESTADO_VISITA_VISITADA = "3";

	// Codificaciones
	public static final String ENCODING_ASCII = "ISO-8859-1";
	public static final String ENCODING_UTF8 = "UTF-8";

	// Path del fichero que contiene los mensajes caducados o con reintentos
	// agotados de los interfaces del motor con el exterior
	public static final String DEAD_MESSAGES_INTERFAZ_FILE = "/datos/ab04b/file/eventoerror.txt";

	// Otros
	public static final String VACIO = "";
	public static final String ESPACIO = " ";
	public static final String COMA = ",";
	public static final String GRADO = "º";
	public static final String PATRON_LIKE = "%";
	public static final String SEPARADOR_PUNTO = ".";
	public static final String OPERADOR_IGUAL = "=";

	// PrepareStatement
	public static final int PS_1 = 1;
	public static final int PS_2 = 2;
	public static final int PS_3 = 3;
	public static final int PS_4 = 4;

	public static final String PERIODO_HOY = "1";
	public static final String PERIODO_SEMANA_PASADA = "2";
	public static final String PERIODO_MES_PASADO = "3";

	// Tipos de identificacion NIF/CIF/NIE para J73
	public static final String TIPO_NIF = "N";
	public static final String TIPO_NIE = "E";
	public static final String TIPO_CIF = "C";
	public static final String TIPO_OTROS = "O";
	public static final String NIF = "NIF";
	public static final String CIF = "CIF";
	public static final String OTROS = "Otros";

	public static final List<ElementoCombo> COMBO_SI_NO = new ArrayList<ElementoCombo>(
			Arrays.asList(new ElementoCombo("", "", ""),
					new ElementoCombo(String.valueOf(Constantes.VALUE_NO), "NO",
							"EZ"),
					new ElementoCombo(String.valueOf(Constantes.VALUE_SI), "SI",
							"BAI")));

	public static final List<ElementoCombo> COMBO_TODAS_PENDIENTES = new ArrayList<ElementoCombo>(
			Arrays.asList(
					new ElementoCombo(String.valueOf(Constantes.VALUE_TODAS),
							"TODAS", "GUZTIAK"),
					new ElementoCombo(
							String.valueOf(Constantes.VALUE_PENDIENTES),
							"PENDIENTES", "ZAIN")));

	public static final List<ElementoCombo> COMBO_TIPO_IDENTIF = new ArrayList<ElementoCombo>(
			Arrays.asList(new ElementoCombo("", "", ""),
					new ElementoCombo(Constantes.TIPO_NIF, "NIF", "IFZ"),
					new ElementoCombo(Constantes.TIPO_CIF, "CIF", "IFK"),
					new ElementoCombo(Constantes.TIPO_OTROS, "Otros",
							"Beste batzuk")));

	public static final List<ElementoCombo> COMBO_TIPO_IDENTIF_CON_NIE = new ArrayList<ElementoCombo>(
			Arrays.asList(new ElementoCombo("", "", ""),
					new ElementoCombo(Constantes.TIPO_NIF, "NIF", "IFZ"),
					new ElementoCombo(Constantes.TIPO_NIE, "NIE", "AIZ"),
					new ElementoCombo(Constantes.TIPO_CIF, "CIF", "IFK"),
					new ElementoCombo(Constantes.TIPO_OTROS, "Otros",
							"Beste batzuk")));

	public static final List<ElementoCombo> COMBO_TIPO_IDENTIF_COORD = new ArrayList<ElementoCombo>(
			Arrays.asList(new ElementoCombo("", "", ""),
					new ElementoCombo(Constantes.TIPO_NIF, "NIF", "IFZ"),
					new ElementoCombo(Constantes.TIPO_NIE, "NIE", "AIZ")));

	public static final List<ElementoCombo> COMBO_TAREAS_PENDIENTE = new ArrayList<ElementoCombo>(
			Arrays.asList(new ElementoCombo("", "", ""),
					new ElementoCombo("all", "Todos", "Guztiak"),
					new ElementoCombo("estudio",
							"Pendiente de estudio documentaci&oacute;n",
							"Eu_Pendiente de estudio documentaci&oacute;n"),
					new ElementoCombo("adjuntar_doc_requerimiento",
							"Adjuntar documento de requerimiento",
							"Eu_Adjuntar documento de requerimiento"),
					new ElementoCombo("adjuntar_informe",
							"Adjuntar Informe de visita",
							"Eu_Adjuntar Informe de visita")));

	public static final List<ElementoCombo> COMBO_TAREAS_PENDIENTE_OS = new ArrayList<ElementoCombo>(
			Arrays.asList(new ElementoCombo("", "", ""),
					new ElementoCombo("all", "Todos", "Guztiak"),
					new ElementoCombo("estudio",
							"Pendiente de estudio documentaci&oacute;n",
							"Eu_Pendiente de estudio documentaci&oacute;n"),
					new ElementoCombo("adjuntar_doc_requerimiento",
							"Adjuntar documento de requerimiento",
							"Eu_Adjuntar documento de requerimiento")));

	// Tipos de identificacion NIF/CIF/NIE para J73

	public static final List<Elemento> LISTA_TIPO_IDENTIF_J73 = new ArrayList<Elemento>(
			Arrays.asList(
					new Elemento(Constantes.TIPO_CIF_J73, "CIF", "CIF_eu"),
					new Elemento(Constantes.TIPO_NIF_J73, "NIF", "NIF_eu"),
					new Elemento(Constantes.TIPO_NIE_J73, "NIE", "NIE_eu")));

	public static final String AUTORIDAD_PROVINCIAL = "8";
	public static final String AUTORIDAD_CAV = "9";
	public static final List<Elemento> COMBO_AUTORIDADES_ORDEN_LAKUA = new ArrayList<Elemento>(
			Arrays.asList(
					new Elemento(Constantes.AUTORIDAD_CAV, "Autoridad C.A.V.",
							"Autoridad C.A.V._eu"),
					new Elemento(Constantes.AUTORIDAD_PROVINCIAL,
							"Autoridad Territorial",
							"Autoridad Territorial_eu")));

	public static final List<Elemento> COMBO_AUTORIDADES_ORDEN_DELEGACION = new ArrayList<Elemento>(
			Arrays.asList(new Elemento(Constantes.AUTORIDAD_PROVINCIAL,
					"Autoridad Territorial", "Autoridad Territorial_eu"),
					new Elemento(Constantes.AUTORIDAD_CAV, "Autoridad C.A.V.",
							"Autoridad C.A.V._eu")));
	// Pais Vasco
	public static final String COD_AUTONOMIA_PAIS_VASCO = "16";

	/** The Constant CTE_MASCARA_FECHA_DIA_MES_ANO. */
	public static final String CTE_MASCARA_FECHA_DIA_MES_ANO = "dd/MM/yyyy";

	public static final Integer INDTIPCENTRO_J73 = 1;

	// Tipos de identificacion NIF/CIF/NIE para J73
	public static final String TIPO_CIF_J73 = "0";
	public static final String TIPO_NIF_J73 = "1";
	public static final String TIPO_NIE_J73 = "2";

	public static final String CAMPO_DNI_LENGTH_STR = "10";

	public static final String ID_PAIS_ESPANA = "108";

	public static final String LABEL_OPCION_NULA_COMBO = "---";

	// Tipo de comunicacion reenvio
	public static final String TIPO_COMUNICACION_REENVIO_APERTURA = "APERTURA";
	public static final String TIPO_COMUNICACION_REENVIO_OS3 = "OS3";
	public static final String TIPO_COMUNICACION_REENVIO_OS2 = "OS2";

	// Delegaciones
	public static final String DEL_LAKUA = "99";
	public static final String DEL_ALAVA = "01";
	public static final String DEL_BIZKAIA = "48";
	public static final String DEL_GIPUZKOA = "20";

	public static final String DESC_DEL_LAKUA = "LAKUA";
	public static final String DESC_DEL_ALAVA = "ARABA";
	public static final String DESC_DEL_BIZKAIA = "BIZKAIA";
	public static final String DESC_DEL_GIPUZKOA = "GIPUZKOA";

	public static final List<ElementoCombo> COMBO_DELEGACIONES = new ArrayList<ElementoCombo>(
			Arrays.asList(
					new ElementoCombo("", Constantes.LABEL_OPCION_NULA_COMBO,
							Constantes.LABEL_OPCION_NULA_COMBO),
					new ElementoCombo(Constantes.DEL_ALAVA,
							Constantes.DEL_ALAVA + " - "
									+ Constantes.DESC_DEL_ALAVA,
							Constantes.DEL_ALAVA + " - "
									+ Constantes.DESC_DEL_ALAVA),
					new ElementoCombo(Constantes.DEL_GIPUZKOA,
							Constantes.DEL_GIPUZKOA + " - "
									+ Constantes.DESC_DEL_GIPUZKOA,
							Constantes.DEL_GIPUZKOA + " - "
									+ Constantes.DESC_DEL_GIPUZKOA),
					new ElementoCombo(Constantes.DEL_BIZKAIA,
							Constantes.DEL_BIZKAIA + " - "
									+ Constantes.DESC_DEL_BIZKAIA,
							Constantes.DEL_BIZKAIA + " - "
									+ Constantes.DESC_DEL_BIZKAIA)));

	public static final List<ElementoCombo> COMBO_DELEGACIONES_MAS_LAKUA = new ArrayList<ElementoCombo>(
			Arrays.asList(new ElementoCombo(Constantes.DEL_LAKUA,
					Constantes.DEL_LAKUA + " - " + Constantes.DESC_DEL_LAKUA,
					Constantes.DEL_LAKUA + " - " + Constantes.DESC_DEL_LAKUA),
					new ElementoCombo(Constantes.DEL_ALAVA,
							Constantes.DEL_ALAVA + " - "
									+ Constantes.DESC_DEL_ALAVA,
							Constantes.DEL_ALAVA + " - "
									+ Constantes.DESC_DEL_ALAVA),
					new ElementoCombo(Constantes.DEL_GIPUZKOA,
							Constantes.DEL_GIPUZKOA + " - "
									+ Constantes.DESC_DEL_GIPUZKOA,
							Constantes.DEL_GIPUZKOA + " - "
									+ Constantes.DESC_DEL_GIPUZKOA),
					new ElementoCombo(Constantes.DEL_BIZKAIA,
							Constantes.DEL_BIZKAIA + " - "
									+ Constantes.DESC_DEL_BIZKAIA,
							Constantes.DEL_BIZKAIA + " - "
									+ Constantes.DESC_DEL_BIZKAIA)));

	public static final List<ElementoCombo> COMBO_DELEGACIONES_LAKUA = new ArrayList<ElementoCombo>(
			Arrays.asList(new ElementoCombo(Constantes.DEL_LAKUA,
					Constantes.DEL_LAKUA + " - " + Constantes.DESC_DEL_LAKUA,
					Constantes.DEL_LAKUA + " - " + Constantes.DESC_DEL_LAKUA)));

	public static final List<ElementoCombo> COMBO_DELEGACIONES_ARABA = new ArrayList<ElementoCombo>(
			Arrays.asList(new ElementoCombo(Constantes.DEL_ALAVA,
					Constantes.DEL_ALAVA + " - " + Constantes.DESC_DEL_ALAVA,
					Constantes.DEL_ALAVA + " - " + Constantes.DESC_DEL_ALAVA)));

	public static final List<ElementoCombo> COMBO_DELEGACIONES_GIPUZKOA = new ArrayList<ElementoCombo>(
			Arrays.asList(new ElementoCombo(Constantes.DEL_GIPUZKOA,
					Constantes.DEL_GIPUZKOA + " - "
							+ Constantes.DESC_DEL_GIPUZKOA,
					Constantes.DEL_GIPUZKOA + " - "
							+ Constantes.DESC_DEL_GIPUZKOA)));

	public static final List<ElementoCombo> COMBO_DELEGACIONES_BIZKAIA = new ArrayList<ElementoCombo>(
			Arrays.asList(new ElementoCombo(Constantes.DEL_BIZKAIA,
					Constantes.DEL_BIZKAIA + " - "
							+ Constantes.DESC_DEL_BIZKAIA,
					Constantes.DEL_BIZKAIA + " - "
							+ Constantes.DESC_DEL_BIZKAIA)));

	public static final String PARAMETRO_DATOS_NAVEGACION = "datosNavegacion";
	public static final String PARAMETRO_ACCION = "action";
	public static final String PARAMETRO_CAMBIOS = "hayCambios";

	public static final String APE = "APE";
	public static final String OS2 = "OS2";
	public static final String OS3 = "OS3";

	public static final String VALUE_OTRO = "O";
	public static final String OTRO_ES = "Otro";
	public static final String OTRO_EU = "Beste bat";

	// Meses
	public static final String ENERO = "Enero";
	public static final String FEBRERO = "Febrero";
	public static final String MARZO = "Marzo";
	public static final String ABRIL = "Abril";
	public static final String MAYO = "Mayo";
	public static final String JUNIO = "Junio";
	public static final String JULIO = "Julio";
	public static final String AGOSTO = "Agosto";
	public static final String SEPTIEMBRE = "Septiembre";
	public static final String OCTUBRE = "Octubre";
	public static final String NOVIEMBRE = "Noviembre";
	public static final String DICIEMBRE = "Diciembre";
	public static final String ENERO_EU = "Urtarrilla";
	public static final String FEBRERO_EU = "Otsaila";
	public static final String MARZO_EU = "Martxoa";
	public static final String ABRIL_EU = "Apirila";
	public static final String MAYO_EU = "Maiatza";
	public static final String JUNIO_EU = "Ekaina";
	public static final String JULIO_EU = "Uztaila";
	public static final String AGOSTO_EU = "Abuztua";
	public static final String SEPTIEMBRE_EU = "Iraila";
	public static final String OCTUBRE_EU = "Urria";
	public static final String NOVIEMBRE_EU = "Azaroa";
	public static final String DICIEMBRE_EU = "Abendua";

	public static final String AGRUPACION_SECTOR = "0";
	public static final String AGRUPACION_CNAE_CTR = "1";
	public static final String AGRUPACION_CNAE_EMP = "2";

	public final static String CONSTANTE_DATE_DIFF = "10";
	public static final int TAMANYO_3000 = 3000;
	public static final int STRING_BUILDER_INIT = 4096;
	public static final int CIENTO_TREINTA = 130;
	public static final int CIEN = 100;
	public static final int DIEZ = 10;
	public static final int UNO = 1;
	public static final int DOS = 2;
	public static final int TRES = 3;
	public static final int CUATRO = 4;
	public static final int NUEVE = 9;

	// Titular o representante
	public static final String SOLICITANTE_TITULAR = "T";
	public static final String SOLICITANTE_REPRESENTANTE = "R";

	public static final String T04_TABLA_TECNI = "TECNI";

	public static final String VALUE_OS4 = "OS4";
	public static final String VALUE_OS6 = "OS6";

	public static final String DATE_PATTERN_YEAR = "yyyy";

	public static final String EXPEDIENTE_CREADO_OK = "ab04b_mensajes.okGenerico";

	public static final String TIPO_PARTICIP_TITULAR = "01";
	public static final String TIPO_PARTICIP_REPRESENTANTE = "02";
	public static final String TIPO_PARTICIP_COORDINADOR_EJEC = "03";
	public static final String TIPO_PARTICIP_COORDINADOR_ELAB = "04";
	public static final String TIPO_PARTICIP_PROMOTOR = "05";
	public static final String TIPO_PARTICIP_PROYECTISTA = "06";

	public static final String PLATEA_TIMESTAMP_FORMAT = "dd/MM/yyyy HH:mm:ss";
	public static final String PLATEA_TIMESTAMP_FORMAT_EU = "yyyy/MM/dd HH:mm:ss";
	public static final String PUNTO = ".";

	// Listados
	public static final String NO_SE_CITAN = "No se citan";
	public static final String DE1A5 = "De 1 a 5";
	public static final String DE6A10 = "De 6 a 10";
	public static final String DE11A15 = "De 11 a 15";
	public static final String DE16A20 = "De 16 a 20";
	public static final String DE21A25 = "De 21 a 25";
	public static final String DE26A30 = "De 26 a 30";
	public static final String DE31A35 = "De 31 a 35";
	public static final String DE36A40 = "De 36 a 40";
	public static final String DE41A45 = "De 41 a 45";
	public static final String DE46A50 = "De 46 a 50";
	public static final String MASDE50 = "Más de 50";

	// Nombres de listados
	public static final String LIS_COM_APE_PDF = "listadoComunicacionApertura.pdf";
	public static final String LIS_COM_APE_NUM_PDF = "listadoComunicacionAperturaNum.pdf";
	public static final String LIS_SIN_INF_OS_PDF = "listadoSinInfoOsalan.pdf";
	public static final String LIS_ANU_MES_TER_PDF = "listadoAnualMesTer.pdf";
	public static final String LIS_ANU_SEC_TER_PDF = "listadoAnualSecTer.pdf";
	public static final String LIS_BIANU_MES_TER_PDF = "listadoBianualMesTer.pdf";
	public static final String LIS_TRAM_TRAB_PDF = "listadoTramosTrabajadores.pdf";
	public static final String LIS_TRAM_TRAB_CEN_PDF = "listadoTramosTrabajadoresPorCentro.pdf";
	public static final String LIS_TRAM_TRAB_TRAB_PDF = "listadoTramosTrabajadoresPorTrab.pdf";
	public static final String LIS_SUB_PDF = "listadoSubsanacion.pdf";
	public static final String LIS_EST_FORM_PRE_PDF = "listadoEstadisticaFormaPre.pdf";
	public static final String LIS_EST_PREV_PDF = "listadoEstadisticaPrev.pdf";

	public static final String SEPARADOR_ALMOHADILLAS = "##";

	public static final int ID_TAREA_ADJUNTAR_INFORME_OSALAN = 22;

	public static final int ID_TAREA_ACUSE_R_APE = 47;

	public static final int ID_TAREA_ACUSE_R_OS2 = 48;

	public static final int ID_TAREA_ACUSE_R_OS3 = 49;
}
